<?php $__env->startSection('content'); ?>
    <!--main content  -->
    <section class="main-bg enter-teams d-flex align-items-center link-page">
        <div class="container text-center mt-3">
            <h1 class="text-white mb-4">Links</h1>
            <div class="row w-100 my-5 top-position">
                <div class="col-md-4">
                    <p class=" text-red ms-3">Red Team</p>
                    <a href="<?php echo e(route('game-players', [$team->room_id, $team->red_team])); ?>" target="_blank" class="text-white text-decoration-none wrap-text"  id="redTeamLink"><?php echo e(route('game-players', [$team->room_id, $team->red_team])); ?></a>
                    <div class="d-flex mt-3 gap-2 justify-content-center">
                        <div class="icon-box border border-danger rounded-circle">
                            <a href="<?php echo e(route('game-players', [$team->room_id, $team->red_team])); ?>" target="_blank">
                                <i class="fa fa-external-link text-red" aria-hidden="true"></i>
                            </a>
                        </div>
                        <div class="icon-box border border-danger rounded-circle" onclick="copyToClipboard(this)" data-link="redTeamLink">
                            <i class="fa fa-clone text-red clone-icon" aria-hidden="true" data-toggle="tooltip" data-placement="top"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <p class=" text-blue ms-3">Blue Team</p>
                    <a href="<?php echo e(route('game-players', [$team->room_id, $team->blue_team])); ?>" target="_blank" class="text-white text-decoration-none wrap-text" id="blueTeamLink"><?php echo e(route('game-players', [$team->room_id, $team->blue_team])); ?></a>
                    <div class="d-flex mt-3 gap-2 justify-content-center">
                        <div class="icon-box border border-primary rounded-circle">
                            <a href="<?php echo e(route('game-players', [$team->room_id, $team->blue_team])); ?>" target="_blank">
                                <i class="fa fa-external-link text-blue" aria-hidden="true"></i>
                            </a>
                        </div>
                        <div class="icon-box border border-primary rounded-circle" onclick="copyToClipboard(this)" data-link="blueTeamLink">
                            <i class="fa fa-clone text-blue clone-icon" aria-hidden="true" data-toggle="tooltip" data-placement="top"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <p class=" text-yellow ms-3">Spectator</p>
                    <a href="<?php echo e(route('game-players', [$team->room_id])); ?>" target="_blank" class="text-white text-decoration-none wrap-text" id="spectatorLink"><?php echo e(route('game-players', [$team->room_id])); ?></a>
                    <div class="d-flex mt-3 gap-2 justify-content-center">
                        <div class="icon-box border border-yellow rounded-circle">
                            <a href="<?php echo e(route('game-players', [$team->room_id])); ?>" target="_blank" onclick="javascript:openWindow(this.href);return false;">
                                <i class="fa fa-external-link text-yellow" aria-hidden="true"></i>
                            </a>
                        </div>
                        <div class="icon-box border border-yellow rounded-circle" onclick="copyToClipboard(this)" data-link="spectatorLink">
                            <i class="fa fa-clone text-yellow clone-icon" aria-hidden="true" data-toggle="tooltip" data-placement="top"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center gap-3">
                <div class="btn-style orange-border">
                    <a href="<?php echo e(route('teams')); ?>" target="_blank">
                        <Button class="main-btn fw-bold bg-black text-yellow">New Draft</Button>
                    </a>
                </div>
                <div class="btn-style orange-border">
                    <Button class="main-btn fw-bold bg-black text-yellow" onclick="copyAllLinks(this)">Copy All</Button>
                </div>
                <div class="btn-style orange-border">
                    <Button class="main-btn fw-bold bg-black text-yellow" onclick="openAllLinks()">Open All</Button>
                </div>
            </div>
        </div>
        <div id="copy-text-div"></div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    function openAllLinks() {
        const links = [
            "<?php echo e(route('game-players', [$team->room_id, $team->red_team])); ?>",
            "<?php echo e(route('game-players', [$team->room_id, $team->blue_team])); ?>",
            "<?php echo e(route('game-players', [$team->room_id])); ?>"
        ];

        links.forEach((link, index) => {
            window.open(link, '_blank');
        });
    }

    function copyToClipboard(el) {
        var id = $(el).data('link');
        var link = document.getElementById(id).href;
        navigator.clipboard.writeText(link).then(() => {
            $(el).find('i').attr('title', "Link copied to clipboard!");
            $(el).find('i').tooltip('show');
            setTimeout(function () {
                $(el).find('i').tooltip('hide');
            }, 2000);
        });
    }

    function copyAllLinks(el) {
        var blueTeamLink = $('#blueTeamLink').attr('href');
        var redTeamLink = $('#redTeamLink').attr('href');
        var spectatorLink = $('#spectatorLink').attr('href');
        var text = 'Red: '+redTeamLink + '\nBlue: '+blueTeamLink + '\nSpectator: '+spectatorLink;

        navigator.clipboard.writeText(text).then(() => {
            $(el).attr('data-bs-original-title', "All Links copied to clipboard!");
            $(el).tooltip('show');
            setTimeout(function () {
                $(el).tooltip('hide');
                $(el).removeAttr('data-bs-original-title');
            }, 2000);
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/appdeft.in/apexjonathan.appdeft.in/resources/views/panel/link.blade.php ENDPATH**/ ?>