var roomId = $('#room_id').val();
var loaderImageUrl = $('#loader').val();
const redBlueTeamChamp = '#champion_8, #champion_9, #champion_12, #champion_17, #champion_20, #champion_7, #champion_10, #champion_11, #champion_18, #champion_19';

$(document).ready(function () {
    var teamType = $('#team_type').val();
    var teamButtonType = $('#'+teamType+'_button_type').val();
    $('.status-buttom').prop('hidden', true);
    $('#'+teamButtonType).prop('hidden', false);
    if ($('#blue_button_type').val() == 'finish' && teamType == 'spectator') {
        $('#finish').prop('hidden', false);
        $('#exportLink').prop('hidden', true);
        $('#exportLink').parent('div').removeClass('d-flex');
    }

    if ($('#blue_button_type').val() == 'waiting' && $('#red_button_type').val() == 'ready') {
        $('.blue-modal').modal('show');
        $('#waiting-message').text('Waiting For Red Team');
    } else if ($('#blue_button_type').val() == 'ready' && $('#red_button_type').val() == 'waiting') {
        $('.red-modal').modal('show');
        $('#waiting-message').text('Waiting For Blue Team');
    }

    $('.blue-team-status').text($('#blue_button_type').val() == 'ready' ? 'Not Ready' : 'Ready');
    $('.red-team-status').text($('#red_button_type').val() == 'ready' ? 'Not Ready' : 'Ready');

    if ($('#champion_1').hasClass('active-img') ||  $('#champion_1').hasClass('empty')) {
        for (let i = 1; i <= 20; i++) {
            if (!$('#champion_'+i).hasClass('active-img') && !$('#champion_'+i).hasClass('empty')) {
                $('#champion_'+i).parent('div').addClass('highlighter');
                break;
            }
        }
    } else if (!$('#champion_1').hasClass('active-img') && $('#blue_button_type').val() != 'ready' && $('#red_button_type').val() != 'ready' && !$('#champion_1').hasClass('empty')) {
        $('#champion_1').parent('div').addClass('highlighter');
    }

    if ($('.highlighter img').is(redBlueTeamChamp)) {
        if ($('#blue_button_type').val() == 'lock') {
            $('.red_import').each(function(index, element) {
                if (!$(element).hasClass('blue_import') && $('#red_ban').val() == 'On') {
                    $(element).removeClass('lock');
                }
            });
        } else if ($('#red_button_type').val() == 'lock') {
            $('.blue_import').each(function(index, element) {
                if (!$(element).hasClass('red_import') && $('#blue_ban').val() == 'On') {
                    $(element).removeClass('lock');
                }
            });
        }
    }
});


$(document).ready(function () {
    if ($('#blue_team_time').val() || $('#red_team_time').val()) {
        var time = $('#red_team_time').val() ? $('#red_team_time').val() : $('#blue_team_time').val();
        if (['lock', 'wating'].includes($('#blue_button_type').val()) || ['lock', 'wating'].includes($('#red_button_type').val())) {
            var remainingTime = time % 30;

            var timeLeft = Math.ceil(remainingTime);
            countDown(timeLeft);
        }
    }

    $(".select-btn").click(function () {
        $(".select-btn").addClass("green-border");
        $(".select-btn1").addClass("white-border");
        $(".select-btn").removeClass("white-border");
        $(".select-btn1").removeClass("green-border");
    });
    $(".select-btn1").click(function () {
        $(".select-btn1").addClass("green-border");
        $(".select-btn").addClass("white-border");
        $(".select-btn").removeClass("green-border");
        $(".select-btn1").removeClass("white-border");
    });

    var teamType = $('#team_type').val();
    $(".players-img").click(function () {
        if ($('#lock_btn').hasClass('loading')) {
            return;
        }
        $('#lock_btn').prop('disabled', false);
        var buttonType = $('#'+teamType+'_button_type').val();

        if (buttonType == 'lock') {
            var lockPlayer = $('.players-img.lock').length;
            var importPlayer = $('.players-img.lock.red_import').length + $('.players-img.lock.blue_import').length;
            var actuallockPlayer = lockPlayer - importPlayer;

            if (!$(this).hasClass('lock') && actuallockPlayer < 20) {
                $(".players-img").removeClass("active");
                $(this).addClass("active");
                $('.default-img').removeClass('active-img');

                var bansImageSrc = $(this).children('img').data('tiles');
                var playersImageSrc = $(this).children('img').data('splash');
                // var playersName = $(this).data('name');
                for (let i = 1; i <= 20; i++) {
                    if (!$('#champion_'+i).hasClass('active-img') && !$('#champion_'+i).hasClass('empty')) {
                        if ($('#champion_'+i).parent('div').hasClass('bans')) {
                            var imageSrc = bansImageSrc;
                        } else {
                            var imageSrc = playersImageSrc;
                        }
                        // $('#champion_'+i+'-name').text(playersName);
                        $('#champion_'+i).attr('src', imageSrc);
                        $('#champion_'+i).addClass('active-img');


                        var data = {
                            'roomId': roomId,
                            'action': 'activeImage',
                            'teamType': teamType,
                            'id': 'champion_'+i,
                            'image': imageSrc,
                            'currentElement': $(this).attr('id')
                        };

                        socket.emit('sendRequest', data);

                        return;
                    }
                }
            }
        }
    });

    var countdownInterval;

    function countDown(timeLeftVal=0) {
        $('#waitingModal').modal('hide');
        var $countdownElement = $('#countdown');
        var timeLeft = 30 - timeLeftVal;

        clearInterval(countdownInterval);

        countdownInterval = setInterval(function() {
            if (timeLeft <= 0) {
                clearInterval(countdownInterval);
                countDown();

                var data = {
                    'roomId': roomId,
                    'action': 'lock',
                    'teamType': teamType
                };
                if ($('.highlighter').hasClass(teamType)) {
                    socket.emit('sendRequest', data);
                }
            } else {
                $('.timer-section').prop('hidden', false);
                $countdownElement.text(timeLeft);
                newTeamType = $('.highlighter').hasClass('red') ? 'Red Team' : 'Blue Team';
                $('#countdown_title').text(newTeamType);
            }
            timeLeft -= 1;
        }, 1000);
    }

    function incrementId(id) {
        id = id ? id : 'champion_1';
        var matches = id.match(/(\d+)$/);
        if (matches) {
            var number = parseInt(matches[0], 10);
            var newNumber = number + 1;
            return id.replace(/\d+$/, newNumber);
        }
        return id;
    }

    // function lockBtn(data) {
    //     $('.players-img.active').addClass('lock');
    //     $('.default-img.active-img').removeClass('default-img');

    //     var highlighterId = $('.highlighter').children('img').attr('id');
    //     $('.players-img.active').addClass(highlighterId);
    //     $('.players-img').removeClass('active');
    //     $('.highlighter').removeClass('highlighter');

    //     var newId = incrementId(highlighterId);
    //     $('#' + newId).parent('div').addClass('highlighter');

    //     if (newId == 'champion_21') {
    //         $('#waiting').prop('hidden', true);
    //         $('#lock').prop('hidden', true);
    //         $('#finish').prop('hidden', false);
    //         $('#countdown').prop('hidden', true);
    //         $('#countdown').parent('div').prop('hidden', true);
    //         clearInterval(countdownInterval);
    //     } else {
    //         countDown();
    //         newTeamType = data.teamType == 'red' ? 'Blue Team' : 'Red Team';
    //         $('#countdown_title').text(newTeamType);
    //     }

    //     if (teamType == 'spectator') {
    //         return;
    //     }
    //     if (data.teamType != teamType) {
    //         if (newId == 'champion_21') {
    //             $('#'+teamType+'_button_type').val('finish');
    //             $('#'+data.teamType+'_button_type').val('finish');
    //         } else {
    //             $('#waiting').prop('hidden', true);
    //             $('#lock').prop('hidden', false);
    //             $('#'+teamType+'_button_type').val('lock');
    //             $('#'+data.teamType+'_button_type').val('waiting');
    //         }
    //     } else {
    //         if (newId == 'champion_21') {
    //             $('#'+teamType+'_button_type').val('finish');
    //             $('#'+data.teamType+'_button_type').val('finish');
    //         } else {
    //             $('#waiting').prop('hidden', false);
    //             $('#lock').prop('hidden', true);
    //             var oppTeamType = teamType == 'red' ? 'blue' : 'red';
    //             $('#'+oppTeamType+'_button_type').val('lock');
    //             $('#'+teamType+'_button_type').val('waiting');
    //         }
    //     }
    // }

    function lockBtn(data) {
        const activePlayers = $('.players-img.active');
        activePlayers.addClass('lock');
        if (activePlayers.hasClass('red_import') || activePlayers.hasClass('blue_import')) {
            if (activePlayers.hasClass('red_import')) {
                activePlayers.removeClass('red_import');
            } else {
                activePlayers.removeClass('blue_import');
            }
        }
        $('.default-img.active-img').removeClass('default-img');

        const highlighterId = $('.highlighter').children('img').attr('id');
        if ($('#'+highlighterId).hasClass('default-img')) {
            $('#'+highlighterId).addClass('empty')
        }
        activePlayers.addClass(highlighterId);
        activePlayers.removeClass('active');
        $('.highlighter').removeClass('highlighter');

        const newId = incrementId(highlighterId);
        $('#' + newId).parent('div').addClass('highlighter');

        const isFinalChampion = newId === 'champion_21';
        const teamTypeButtons = (type) => $(`#${type}_button_type`);

        if (isFinalChampion) {
            $('#waiting, #lock, #countdown').prop('hidden', true);
            $('#countdown').parent('div').prop('hidden', true);
            $('#finish').prop('hidden', false);
            $('#ban_div').prop('hidden', true);
            if (teamType == 'spectator') {
                $('#exportLink').prop('hidden', true);
                $('#exportLink').parent('div').removeClass('d-flex');
            }
            clearInterval(countdownInterval);
        } else {
            countDown();
            var timerText = 'Blue Team';
            if ($('.highlighter').hasClass('red')) {
                timerText = 'Red Team';
            }
            // $('#countdown_title').text(data.teamType === 'red' ? 'Blue Team' : 'Red Team');
            $('#countdown_title').text(timerText);
        }

        if (teamType === 'spectator') {
            return;
        }

        if ($('.highlighter').hasClass('red')) {
            var currentTeamColor = 'red';
        } else {
            var currentTeamColor = 'blue';
        }

        $('.red_import, .blue_import').addClass('lock');
        if (['champion_8', 'champion_9', 'champion_12', 'champion_17', 'champion_20'].includes(newId) && $('.highlighter').hasClass('red')) {
            $('.blue_import').each(function(index, element) {
                if (!$(element).hasClass('red_import') && $('#blue_ban').val() != 'Off') {
                    $(element).removeClass('lock');
                }
            });
        } else if (['champion_7', 'champion_10', 'champion_11', 'champion_18', 'champion_19'].includes(newId) && $('.highlighter').hasClass('blue')) {
            $('.red_import').each(function(index, element) {
                if (!$(element).hasClass('blue_import') && $('#red_ban').val() != 'Off') {
                    $(element).removeClass('lock');
                }
            });
        }

        if (data.teamType == currentTeamColor) {
            return;
        }

        if (data.teamType !== teamType) {
            if (isFinalChampion) {
                teamTypeButtons(teamType).val('finish');
                teamTypeButtons(data.teamType).val('finish');
            } else {
                $('#waiting').prop('hidden', true);
                $('#lock').prop('hidden', false);
                teamTypeButtons(teamType).val('lock');
                teamTypeButtons(data.teamType).val('waiting');
            }
        } else {
            const oppTeamType = teamType === 'red' ? 'blue' : 'red';
            if (isFinalChampion) {
                teamTypeButtons(teamType).val('finish');
                teamTypeButtons(oppTeamType).val('finish');
            } else {
                $('#waiting').prop('hidden', false);
                $('#lock').prop('hidden', true);
                teamTypeButtons(oppTeamType).val('lock');
                teamTypeButtons(teamType).val('waiting');
            }
        }
    }

    const socket = io(socketUrl);

    function readyBtn(data) {
        var nextTeam = data.teamType == 'blue' ? 'Red' : 'Blue';
        if (data.teamType == teamType) {
            $('#importBtn').prop('hidden', true);
            $('#filterImportBtn').prop('hidden', false);
            $('#ban_div').prop('hidden', false);
            // $('#search-section').removeClass('d-flex gap-2');
        }
        $('#waiting-message').text(`Waiting For ${nextTeam} Team`);
        $('#'+data.teamType+'_button_type').val('waiting');
        $('.'+data.teamType+'_ready').prop('hidden', true);
        $('.'+data.teamType+'_waiting').prop('hidden', false);
        $('.'+data.teamType+'-team-status').text('Ready');

        if ($('#blue_button_type').val() == 'waiting' && $('#red_button_type').val() == 'waiting') {
            $('#blue_button_type').val('lock');
            $('.blue_ready').prop('hidden', true);
            $('.blue_waiting').prop('hidden', true);
            $('.blue_lock').prop('hidden', false);
            $('#champion_1').parent('div').addClass('highlighter');
            $('#waitingModal').modal('hide');
            $('#countdown').parent('div').prop('hidden', false);
            $('.select-player').prop('hidden', false);
            $('#waiting-screen').prop('hidden', true);
            $('.sidebar-toggle').prop('hidden', false);
            countDown();
        } else {
            $('.'+data.teamType+'-modal#waitingModal').modal('show');
        }
    }
    $('#ready_btn').on('click', function() {
        console.log('ready');
        if ($(this).hasClass('loading')) {
            return;
        }

        $(this).text('');
        $(this).html('<img src="' + loaderImageUrl + '" class="loader" alt="">');
        $(this).addClass('loading');

        var data = {
            'roomId': roomId,
            'action': 'ready',
            'teamType': teamType
        };

        socket.emit('sendRequest', data);
    });

    $('#lock_btn').on('click', function() {
        console.log('lock');
        if ($(this).hasClass('loading')) {
            return;
        }

        $('#lock_btn').prop('disabled', true);
        if ($('.players-img').hasClass('active')) {
            $(this).text('');
            $(this).html('<img src="' + loaderImageUrl + '" class="loader" alt="">');
            $(this).addClass('loading');

            var data = {
                'roomId': roomId,
                'action': 'lock',
                'teamType': teamType
            };

            socket.emit('sendRequest', data);
        }
    });

    socket.on("receiveRequest", (data) => {
        if (data.roomId == roomId) {
            if (data.action == 'activeImage') {
                $('#' + data.id).attr('src', data.image);
                $(".players-img").removeClass("active");
                $('#' + data.currentElement).addClass("active");
                $('#' + data.id).addClass('active-img');
            } else if (data.action == 'lock') {
                console.log('S-Lock');
                lockBtn(data);
                if (teamType == data.teamType) {
                    ajax(data);
                }
                $('#lock_btn').prop('disabled', false);
                $('#lock_btn').text('Lock');
                $('#lock_btn').removeClass('loading');
            } else if (data.action == 'ready') {
                readyBtn(data)
                if (teamType == data.teamType) {
                    ajax(data);
                }
            } else if (data.action == 'disable') {
                console.log(data.res.data);
                var teamData = data.res.data;
                $('.'+data.teamType+'_import').removeClass('lock ' + data.teamType+'_import');
                teamData.forEach(playerId => {
                    $('#players-img-'+playerId).addClass('lock');
                    $('#players-img-'+playerId).addClass(data.teamType+'_import');
                });
            } else if (data.action == 'cancel_ready') {
                $('#importBtn').prop('hidden', false);
                $('#filterImportBtn').prop('hidden', true);
                $('#ban_div').prop('hidden', true);

                $('#waitingModal').modal('hide');
                $('#'+data.teamType+'_button_type').val('ready');
                $('.'+data.teamType+'_ready').prop('hidden', false);
                $('.'+data.teamType+'_waiting').prop('hidden', true);
                $('.'+data.teamType+'-team-status').text('Not Ready');
                $('#ready_btn').text('Ready');
                $('#ready_btn').removeClass('loading');

                $.ajax({
                    type: "GET",
                    url: "/cancel/"+data.roomId,
                    success: function(res) {
                        console.log(res);
                    }
                });
            } else if (data.action == 'ban_player') {
                var banValue = data.value == 'On' ? 'Off' : 'On';
                $('#'+data.teamType+'_ban').val(banValue);
                $('#'+data.teamType+'_ban_text').text(banValue);

                $.ajax({
                    type: "POST",
                    url: "/ban-player/"+data.roomId,
                    data: {
                        _token: $('#_token').val(),
                        value: banValue,
                        team: data.teamType
                    },
                    success: function(res) {
                        if ($('.highlighter img').is(redBlueTeamChamp)) {
                            if (data.teamType == 'red' && $('.highlighter').hasClass('blue')) {
                                $('.red_import').each(function(index, element) {
                                    if (!$(element).hasClass('blue_import') && $('#red_ban').val() != 'Off') {
                                        $(element).removeClass('lock');
                                    } else {
                                        $(element).addClass('lock');
                                    }
                                });
                            } else if (data.teamType == 'blue' && $('.highlighter').hasClass('red')) {
                                $('.blue_import').each(function(index, element) {
                                    if (!$(element).hasClass('red_import') && $('#blue_ban').val() != 'Off') {
                                        $(element).removeClass('lock');
                                    } else {
                                        $(element).addClass('lock');
                                    }
                                });
                            }
                        }
                    }
                });
            } else {
                console.log('#');
            }
        }
    });

    function ajax(data) {
        var url = $('#room_url').val();
        var _token = $('#_token').val();
        var blue_button_type = $('#blue_button_type').val();
        var red_button_type = $('#red_button_type').val();

        var champions = {};
        for (var i = 1; i <= 20; i++) {
            champions['champion' + i] = $('.players-img.lock.champion_' + i).data('id');
            if ($('#champion_'+i).hasClass('empty')) {
                champions['champion' + i] = 'empty';
            }
        }

        $.ajax({
            url: url,
            type: "POST",
            data: Object.assign({
                _token: _token,
                blue_button_type: blue_button_type,
                red_button_type: red_button_type,
                data: data
            }, champions),
            success: function(res) {}
        });
    }

    $(".filter-img").click(function () {
        $('.filter-img').not(this).removeClass('highlight');
        if ($(this).hasClass('highlight')) {
            $(this).removeClass('highlight');
            $('.players-img').css('display', 'block')
        } else {
            $(this).addClass('highlight');

            const type = $(this).data('type');
            $('.players-img').each(function() {
                const typeValue = $(this).data(type).toString().toLowerCase();
                if (typeValue == '1') {
                    $(this).css('display', 'block');
                } else {
                    $(this).css('display', 'none');
                }
            });
        }
    });

    $(".sidebar-toggle").click(function () {
        $(".sidebar-setting").addClass("show");
    });
    $(".close-sidebar").click(function () {
        $(".sidebar-setting").removeClass("show");
    });
});

function normalizeString(str) {
    return str.replace(/[^a-zA-Z0-9]/g, '').toLowerCase();
}

function search() {
    // const input = normalizeString(document.getElementById('name').value);
    const input = document.getElementById('name').value.toLowerCase();
    const players = document.querySelectorAll('.players-img');

    players.forEach(player => {
        const normalizePlayerName = normalizeString(player.getAttribute('data-name'));
        const playerName = player.getAttribute('data-name').toLowerCase();
        if (normalizePlayerName.includes(input) || playerName.includes(input)) {
            player.style.display = 'block';
        } else {
            player.style.display = 'none';
        }
    });

    // $.ajax({
    //     type: "GET",
    //     url: "/champions?name="+input,
    //     success: function (res) {
    //         $('#champions-images').html(res.data);
    //     }
    // });
}

var teamType = $('#team_type').val();
function play() {
    var soundType = $('#sound-btn').val();
    if (soundType == 'Off') {
        var audio = document.getElementById("audio");
        audio.pause();
        audio.currentTime = 0;
        audio.play();
    }
}

$('#sound-btn').on('click', function() {
    var soundVal = $(this).val();
    if (soundVal == 'Off') {
        $(this).val('On');
        var newVal = 'On';
    } else {
        var newVal = 'Off';
    }
    $(this).val(newVal);

    $.ajax({
        url: $('#sound_url').val(),
        type: "POST",
        data: {
            _token: $('#_token').val(),
            teamType: teamType,
            newVal: newVal,
            type: 'sound'
        },
        success: function(res) {}
    });
});

$('#size-btn').on('click', function() {
    var val = $(this).val();
    var newPathSegment = val == 'Large' ? 'splash' : 'tiles';
    var newVal = val == 'Large' ? 'Small' : 'Large';
    var box = $('.selected-players-box');

    box.find('img').each(function() {
        var src = $(this).attr('src');
        var newSrc = src.replace(/(tiles|splash)/, newPathSegment);
        $(this).attr('src', newSrc);
    });
    box.toggleClass('small', val !== 'Large');
    $(this).val(newVal);

    $.ajax({
        url: $('#sound_url').val(),
        type: "POST",
        data: {
            _token: $('#_token').val(),
            teamType: teamType,
            newVal: newVal,
            type: 'size'
        },
        success: function(res) {}
    });
});

$('#exportLink').on('click', function() {
    setTimeout(function() {
        $('#exportModal').modal('hide');
    }, 500);
});

$('#captureButton').on('click', function() {
    var modal = $('#exportModal');
    modal.modal('hide');

    setTimeout(function() {
        html2canvas(document.body).then(function(canvas) {
            var link = document.createElement('a');
            link.download = 'screenshot.png';
            link.href = canvas.toDataURL('image/png');
            link.click();
        });
    }, 200);
});

$('.upload-box').on('click', function() {
    $('#fileInput').click();
});

function upload(fd=null) {
    const socket = io(socketUrl);
    var url = $('#fileInput').data('url');

    if (fd) {
        var formData = fd;
    } else {
        var form = $('#file-import-form')[0];
        var formData = new FormData(form);
    }

    formData.append('teamType', teamType);

    $.ajax({
        type: "POST",
        url: url,
        data: formData,
        processData: false,
        contentType: false,
        success: function(res) {
            $('#importModal').modal('hide');
            $('#fileInput').val('');

            // var teamData = res.data[teamType+'_team'];
            // Object.values(teamData).forEach(playerId => {
            //     $('#players-img-'+playerId).addClass('lock');
            // });
            var data = {
                'roomId': roomId,
                'action': 'disable',
                'teamType': teamType,
                'res': res
            };
    
            socket.emit('sendRequest', data);
        },
        error: function(err) {
            console.log('err', err);
        }
    });
}

$('#fileInput').on('change', function() {
    upload();
});

$("html").on("dragover", function(e) {
    e.preventDefault();
    e.stopPropagation();
    $("#drag-drop-text").text("Drag here");
});
$("html").on("drop", function(e) { e.preventDefault(); e.stopPropagation(); });

$('.upload-box').on('dragenter', function (e) {
    e.stopPropagation();
    e.preventDefault();
    $("#drag-drop-text").text("Drop");
});

$('.upload-box').on('dragover', function (e) {
    e.stopPropagation();
    e.preventDefault();
    $("#drag-drop-text").text("Drop");
});

$('.upload-box').on('drop', function (e) {
    e.stopPropagation();
    e.preventDefault();

    $("#drag-drop-text").html(`Drag & Drop<br>or <span class="browse">Browse</span>`);

    var file = e.originalEvent.dataTransfer.files;
    var form = $('#file-import-form')[0];
    var fd = new FormData(form);

    fd.append('file', file[0]);

    upload(fd);
});

$('.filter-import').on('click', function() {
    var val = $(this).data('val');
    var container = $('.players-img').parent();
    var elements = $('.players-img');

    if (val == 'cancel') {
        elements.sort(function(a, b) {
            return $(a).data('id') - $(b).data('id');
        }).css('display', 'block').appendTo(container);
    } else {
        elements.each(function() {
            var element = $(this);
            if (val === 'both') {
                element.css('display', element.hasClass('blue_import') || element.hasClass('red_import') ? 'block' : 'none');
            } else {
                element.css('display', element.hasClass(val + '_import') ? 'block' : 'none');
            }
        });

        var blueAndRedElements = elements.filter('.blue_import.red_import:visible');
        var blueElements = elements.filter('.blue_import:visible').not('.red_import');
        var redElements = elements.filter('.red_import:visible').not('.blue_import');

        container.find('.break-div').remove();
        container.append(blueElements);
        if (blueElements.length && redElements.length) {
            $('<div class="break-div" style="width: 100%;"></div>').appendTo(container);
        }
        container.append(redElements);

        if (blueAndRedElements.length > 0) {
            $('<div class="break-div" style="width: 100%;"></div>').appendTo(container);
        }
        container.append(blueAndRedElements);
    }
});

$('#cancel-btn').on('click', function() {
    const socket = io(socketUrl);
    var data = {
        'roomId': roomId,
        'action': 'cancel_ready',
        'teamType': teamType
    };
    socket.emit('sendRequest', data);
});

$('#ban_div').on('click', function() {
    const socket = io(socketUrl);
    var value = $('#'+teamType+'_ban_text').text();

    var data = {
        'roomId': roomId,
        'action': 'ban_player',
        'teamType': teamType,
        'value': value
    };

    socket.emit('sendRequest', data);
});