<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PanelController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    // return view('welcome');
    return view('panel.index');
});

Route::get('champions', [PanelController::class, 'champions'])->name('champions');
Route::post('update-result/{room_id}', [PanelController::class, 'updateResult'])->name('update-result');
Route::post('update-setting/{room_id}', [PanelController::class, 'updateSetting'])->name('update-setting');
Route::get('export/{room_id}', [PanelController::class, 'export'])->name('export');
Route::post('import/{room_id}', [PanelController::class, 'import'])->name('import');
Route::get('cancel/{room_id}', [PanelController::class, 'cancel'])->name('cancel');
Route::post('ban-player/{room_id}', [PanelController::class, 'banPlayer'])->name('ban-player');

Route::get('teams', [PanelController::class, 'teams'])->name('teams');
Route::post('link', [PanelController::class, 'createLink'])->name('create-link');
Route::get('{room_id}/{password}/{blue_team}/{red_team}', [PanelController::class, 'links'])->name('links');
Route::get('{room_id}/{team_token?}', [PanelController::class, 'gamePlayers'])->name('game-players');
