@extends('layouts.main')

@section('content')


<!--main content  -->
<section class="team-data">
    @php
        if (Request::segment(2)) {
            $teamType = $team->blue_team == Request::segment(2) ? 'blue' : 'red';
        } else {
            $teamType = 'spectator';
        }
        $roomId = Request::segment(1);
        $teamData = json_decode($team->data, true);
        $time = '';
        if ($teamData && (isset($teamData['blue_team_time']) || isset($teamData['red_team_time']))) {
            $currentTime = \Carbon\Carbon::now();
            $oldTime = isset($teamData['blue_team_time']) ? new \Carbon\Carbon($teamData['blue_team_time']) : new \Carbon\Carbon($teamData['red_team_time']);
            $time = $currentTime->diffInSeconds($oldTime);
        }

        $newChampArr = [];
        if ($teamData) {
            foreach (['red_team', 'blue_team'] as $teamVal) {
                foreach ($teamData[$teamVal] as $key => $championId) {
                    if (!empty($championId)) {
                        foreach ($champions as $champion) {
                            if ($champion->id == $championId) {
                                $newChampArr[$key] = $champion->image_name.'_0.jpg';
                                break;
                            } elseif ($championId == 'empty') {
                                $newChampArr[$key] = 'empty';
                                break;
                            }
                        }
                    }
                }
            }
        }

        $teamSoundId = $teamType.'_sound';
        $teamSizeId = $teamType.'_size';

        $imageSizeType = $team->$teamSizeId == 'Large' ? 'splash' : 'tiles';
    @endphp
    <audio id="audio" src="{{ asset('assets/game-start.mp3') }}"></audio>
    {{-- <audio id="audio" src="{{ asset('assets/success-sound.mp3') }}"></audio> --}}
    <input type="hidden" id="sound_url" value="{{ route('update-setting', $roomId) }}">
    <input type="hidden" id="room_url" value="{{ route('update-result', $roomId) }}">
    <input type="hidden" id="blue_team_time" value="{{ isset($teamData['blue_team_time']) ? $time : '' }}">
    <input type="hidden" id="red_team_time" value="{{ isset($teamData['red_team_time']) ? $time : '' }}">
    <input type="hidden" id="_token" value="{{ csrf_token() }}">
    <input type="hidden" id="room_id" value="{{ $roomId }}">
    <input type="hidden" id="team_type" value="{{ $teamType }}">
    <input type="hidden" id="blue_button_type" value="{{ $teamData['blue_team_status'] ?? 'ready' }}"> <!-- value = lock, waiting, ready, finish -->
    <input type="hidden" id="red_button_type" value="{{ $teamData['red_team_status'] ?? 'ready' }}"> <!-- value = lock, waiting, ready, finish -->
    <input type="hidden" id="blue_ban" value="{{ $team['blue_ban'] }}">
    <input type="hidden" id="red_ban" value="{{ $team['red_ban'] }}">
</section>
<div id="waiting-screen" {{ ($teamType != 'spectator') || ($teamData && $teamData['blue_team_status'] != 'ready' && $teamData['red_team_status'] != 'ready') ? 'hidden' : '' }}>
    @include('panel.waiting-page')
</div>
<section class="main-bg select-player" {{ (($teamType == 'spectator') && !is_array($teamData)) ? 'hidden' : '' }}>
    <div class="d-flex ">
        <div class="blue-side p-2 px-5">
            <div class="container p-0 h-auto fs-5 fw-bold text-white text-start">
                {{ $team->blue_name }}
            </div>
        </div>
        <div class="red-side p-2 px-5">
            <div class="container p-0 h-auto fs-5 fw-bold text-white text-end">
                {{ $team->red_name }}
            </div>
        </div>
    </div>
    <div class="d-flex ">
        <div class="left-player-side">
            <div class="d-flex h-100 flex-column gap-1 position-relative p-4 pb-0">
                @php
                    $leftChampions = ['champion_7', 'champion_10', 'champion_11', 'champion_18', 'champion_19'];
                @endphp
                @foreach ($leftChampions as $key => $leftChampion)
                <div class="selected-players-box bg-dark-color d-flex justify-content-center align-items-center blue {{ $team->$teamSizeId == 'Large' ? '' : 'small' }} {{ $key == 2 ? 'mb-4' : '' }}">
                    @if (isset($newChampArr[$leftChampion]) && $newChampArr[$leftChampion] && $newChampArr[$leftChampion] == 'empty')
                        <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img empty" id="{{ $leftChampion }}">
                    @elseif (isset($newChampArr[$leftChampion]) && $newChampArr[$leftChampion])
                        <img src="{{ asset('assets/images/'.$imageSizeType.'/'.$newChampArr[$leftChampion]) }}" alt="" class="active-img" id="{{ $leftChampion }}">
                    @else
                        <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img" id="{{ $leftChampion }}">
                    @endif
                    {{-- <div class="selected-player-name-div text-end" id="{{ $leftChampion }}-name"></div> --}}
                </div>
                @endforeach
            </div>
        </div>
        <div class="all-players-container px-5">
            <div class="row align-items-center justify-content-between my-3">
                <div class="col-4 d-flex gap-3">
                    <img src="{{ asset('assets/images/img/position-top.png') }}" alt="" class="filter-img" data-type="top">
                    <img src="{{ asset('assets/images/img/position-jungle.png') }}" alt="" class="filter-img" data-type="jungle">
                    <img src="{{ asset('assets/images/img/position-middle.png') }}" alt="" class="filter-img" data-type="middle">
                    <img src="{{ asset('assets/images/img/position-bottom.png') }}" alt="" class="filter-img" data-type="bottom">
                    <img src="{{ asset('assets/images/img/position-utility.png') }}" alt="" class="filter-img" data-type="utility">
                </div>
                <div class="col-4 text-center timer-section" hidden>
                    {{-- <img src="{{ asset('assets/images/img/clock.png') }}" alt=""> --}}
                    <span class="text-white" id="countdown">30</span><br>
                    <span class="text-white" id="countdown_title">Blue Team</span>
                </div>
                <div class="col-4">
                    @php
                        $importCondition = $teamType != 'spectator' && $team->type == 'Fearless' && ((isset($teamData) && $teamData[$teamType.'_team_status'] == 'ready') || !isset($teamData));
                        $filterItems = ['both', 'blue', 'red', 'cancel'];
                    @endphp
                    <div class="blue-team text-start {{ ($team->type == 'Fearless') ? 'd-flex gap-2' : '' }}" id="search-section">
                        <div class="input-box bg-white border-white">
                            <input type="name" class="px-4 form-control rounded-0" id="name" placeholder="Search" name="name" autocomplete="off" onkeyup="search()" style="padding: 7px;">
                        </div>
                        @if ($importCondition)
                            <div class="btn-style orange-border" id="importBtn">
                                <Button class="main-btn fw-bold p-2" data-bs-toggle="modal" data-bs-target="#importModal" id="import_btn">Import</Button>
                            </div>
                        @endif
                        @if ($team->type == 'Fearless')
                            <div class="btn-style orange-border dropdown" id="filterImportBtn" {{ $importCondition ? 'hidden' : '' }}>
                                <button class="main-btn fw-bold p-2 dropdown-toggle" type="button" id="filterImportCharacterButton" data-bs-toggle="dropdown" aria-expanded="false">
                                    Pool
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="filterImportCharacterButton">
                                    @foreach ($filterItems as $filterItem)
                                        <li><a class="dropdown-item filter-import" data-val="{{ $filterItem }}" href="javascript:void(0)">{{ ucwords($filterItem) }}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                            <div class="btn-style orange-border" id="ban_div" {{ $importCondition || $teamType == 'spectator' || ($teamData['blue_team_status'] == 'finish' && $teamData['red_team_status'] == 'finish') ? 'hidden' : '' }}>
                                @php $banName = $teamType.'_ban'; @endphp
                                <Button class="main-btn fw-bold p-2" id="{{ $banName }}_btn">Ban: <span id="{{ $banName }}_text">{{ $team[$banName] }}</span></Button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="center-selector-player">
                <div id="champions-images">
                    @include('panel.champions')
                </div>
                <div class="d-flex justify-content-center gap-3">
                    <input type="hidden" id="loader" value="{{ asset('assets/images/icons/white_loader.gif') }}">
                    <div class="btn-style orange-border status-buttom {{ $teamType }}_ready" id="ready" hidden>
                        <Button class="main-btn fw-bold p-2" id="ready_btn" onclick="play()">Ready</Button>
                    </div>
                    <div class="btn-style orange-border status-buttom {{ $teamType }}_lock" id="lock" hidden>
                        <Button class="main-btn fw-bold p-2" id="lock_btn" onclick="play()">Lock</Button>
                    </div>
                    <div class="btn-style status-buttom {{ $teamType }}_waiting" id="waiting" hidden>
                        <button type="button" class="btn main-btn btn-secondary fw-bold p-2" disabled>Waiting...</button>
                    </div>
                    <div class="btn-style status-buttom gap-5" style="display: flex;" id="finish" hidden>
                        <button type="button" class="btn main-btn btn-secondary fw-bold p-2" disabled>Finished</button>
                        <Button type="button" class="btn main-btn btn-secondary green-btn fw-bold p-2" data-bs-toggle="modal" data-bs-target="#exportModal" id="exportBtn">Export</Button>
                    </div>
                </div>
            </div>
        </div>
        <div class="right-player-side ">
            <div class="d-flex h-100 flex-column gap-1 position-relative p-4 pb-0">
                @php
                    $rightChampions = ['champion_8', 'champion_9', 'champion_12', 'champion_17', 'champion_20'];
                @endphp
                @foreach ($rightChampions as $key => $rightChampion)
                <div class="selected-players-box bg-dark-color d-flex justify-content-center align-items-center red {{ $team->$teamSizeId == 'Large' ? '' : 'small' }} {{ $key == 2 ? 'mb-4' : '' }}">
                    @if (isset($newChampArr[$rightChampion]) && $newChampArr[$rightChampion] && $newChampArr[$rightChampion] == 'empty')
                        <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img empty" id="{{ $rightChampion }}">
                    @elseif (isset($newChampArr[$rightChampion]) && $newChampArr[$rightChampion])
                        <img src="{{ asset('assets/images/'.$imageSizeType.'/'.$newChampArr[$rightChampion]) }}" alt="" class="active-img" id="{{ $rightChampion }}">
                    @else
                        <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img" id="{{ $rightChampion }}">
                    @endif
                </div>
                @endforeach
            </div>
        </div>

    </div>
    <div class="row m-0 bottom-player-side d-flex justify-content-between">
        <div class="col-5 d-flex flex-row gap-2 left-bar position-relative p-3 px-4">
            @php
                $bottomLeftChampions = ['champion_1', 'champion_3', 'champion_5', 'champion_14', 'champion_16'];
            @endphp
            @foreach ($bottomLeftChampions as $key => $bottomLeftChampion)
            <div class="bg-dark-color d-flex justify-content-center align-items-center player-box blue bans {{ $key == 2 ? 'me-5' : '' }}">
                @if (isset($newChampArr[$bottomLeftChampion]) && $newChampArr[$bottomLeftChampion] && $newChampArr[$bottomLeftChampion] == 'empty')
                    <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img empty" id="{{ $bottomLeftChampion }}">
                @elseif (isset($newChampArr[$bottomLeftChampion]) && $newChampArr[$bottomLeftChampion])
                    <img src="{{ asset('assets/images/tiles/'.$newChampArr[$bottomLeftChampion]) }}" alt="" class="active-img" id="{{ $bottomLeftChampion }}">
                @else
                    <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img" id="{{ $bottomLeftChampion }}">
                @endif
            </div>
            @endforeach
        </div>
        <div class="col-5 d-flex flex-row gap-2 right-bar position-relative p-3 px-4">
            @php
                $bottomRightChampions = ['champion_15', 'champion_13', 'champion_6', 'champion_4', 'champion_2'];
            @endphp
            @foreach ($bottomRightChampions as $key => $bottomRightChampion)
            <div class="bg-dark-color d-flex justify-content-center align-items-center player-box red bans {{ $key == 2 ? 'ms-5' : '' }}">
                @if (isset($newChampArr[$bottomRightChampion]) && $newChampArr[$bottomRightChampion] && $newChampArr[$bottomRightChampion] == 'empty')
                    <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img empty" id="{{ $bottomRightChampion }}">
                @elseif (isset($newChampArr[$bottomRightChampion]) && $newChampArr[$bottomRightChampion])
                    <img src="{{ asset('assets/images/tiles/'.$newChampArr[$bottomRightChampion]) }}" alt="" class="active-img" id="{{ $bottomRightChampion }}">
                @else
                    <img src="{{ asset('assets/images/img/image 14.png') }}" alt="" class="default-img" id="{{ $bottomRightChampion }}">
                @endif
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- Modal -->
<div class="modal fade {{ $teamType }}-modal" id="waitingModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body p-5 text-center">
                <h2 class="text-white" id="waiting-message">Waiting For Red Team </h2>
                <div class="btn-style orange-border mt-3" id="cancel-btn-div">
                    <Button class="main-btn fw-bold p-2" id="cancel-btn">Cancel</Button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body p-5 text-center">
                <h2 class="text-white" id="export-message">Which export file do you prefer?</h2>
                <div class="btn-style mt-5 d-flex justify-content-between gap-3">
                    <Button class="main-btn fw-bold p-2" id="captureButton">Image</Button>
                    <a href="{{ route('export', $roomId) }}" class="main-btn fw-bold p-2 text-decoration-none" id="exportLink">Export For Fearless</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body p-5 text-center upload-container">
                <h2 class="text-white" id="import-message">Upload your File</h2>
                {{-- <div class="btn-style mt-5 d-flex justify-content-between gap-3">
                    <Button class="main-btn fw-bold p-2" id="captureButton">Image</Button>
                </div> --}}
                <form action="" id="file-import-form" enctype="multipart/form-data" hidden>
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <input type="file" name="file" id="fileInput" class="file-input" accept="application/JSON" data-url="{{ route('import', $roomId) }}">
                </form>
                <div class="upload-box">
                    <img src="{{ asset('assets/images/icons/image-icon.png') }}" alt="Upload Icon" class="upload-icon">
                    <p id="drag-drop-text">Drag & Drop<br>or <span class="browse">Browse</span></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- setting  sidebar-->
<div class="sidebar-setting">
    <div class="sidebar-top-header d-flex align-items-center justify-content-between position-relative z-1 p-4">
        <h4 class="text-yellow m-0">Setting</h4>
        <i class="fa fa-times fs-4 text-yellow close-sidebar"></i>
    </div>
    <div class="sidebar-content p-4 position-relative z-1">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h4 class="text-white m-0">Picks</h4>
            <div class="btn-style orange-border ">
                <input type="button" class="main-btn fw-bold p-2" id="size-btn" value="{{ $team->$teamSizeId == 'Large' ? 'Small' : 'Large' }}">
            </div>
        </div>
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h4 class="text-white m-0">Sound</h4>
            <div class="btn-style orange-border ">
                <input type="button" class="main-btn fw-bold p-2" id="sound-btn" value="{{ $team->$teamSoundId ? 'Off' : 'On' }}">
            </div>
        </div>
    </div>
</div>

@endsection