<div class="d-flex justify-content-center align-items-start flex-wrap gap-1 all-players-box">
    @php
        $lockedChampions = [];
        $championArr = [];

        if ($teamData) {
            foreach (['red_team', 'blue_team'] as $teamT) {
                foreach ($teamData[$teamT] as $key => $championId) {
                    if (!empty($championId)) {
                        $championArr[$key] = $championId;
                        $lockedChampions[] = $championId;
                    }
                }
            }
        }
    @endphp

    @foreach ($champions as $champion)
        @php
            $championId = $champion->id;
            $isLocked = in_array($championId, $lockedChampions);
            $class = array_search($championId, $championArr) ?: '';

            $redImportTeam = json_decode($team['red_import'], true) ?? [];
            $blueImportTeam = json_decode($team['blue_import'], true) ?? [];

            $isImported = '';
            if ($team && !$isLocked) {
                if (in_array($championId, $redImportTeam)) {
                    $isImported = 'red_import';
                }
                if (in_array($championId, $blueImportTeam)) {
                    $isImported = $isImported ? 'red_import blue_import' : 'blue_import';
                }
                $isLocked = ($isImported !== '');
            }
        @endphp
        <div class="players-img {{ $class }} {{ $isLocked ? 'lock' : '' }} {{ $isImported }}"
             data-name="{{ $champion->name }}" data-id="{{ $champion->id }}" id="players-img-{{ $champion->id }}"
             data-top="{{ $champion->top }}" data-jungle="{{ $champion->jungle }}" data-middle="{{ $champion->middle }}" data-bottom="{{ $champion->bottom }}" data-utility="{{ $champion->utility }}">
            <img src="{{ asset('assets/images/champion/'.$champion->image) }}" alt="{{ $champion->name }}" data-splash="{{ asset('assets/images/splash/'.$champion->image_name.'_0.jpg') }}"  data-tiles="{{ asset('assets/images/tiles/'.$champion->image_name.'_0.jpg') }}">
        </div>
    @endforeach
</div>
