<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Champion;

class ChampionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Champion::truncate();
        $champions = [
            ['name' => "Aatrox", 'image' => 'Aatrox.png', 'image_name' => 'Aatrox', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ahri", 'image' => 'Ahri.png', 'image_name' => 'Ahri', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Akali", 'image' => 'Akali.png', 'image_name' => 'Akali', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Akshan", 'image' => 'Akshan.png', 'image_name' => 'Akshan', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Alistar", 'image' => 'Alistar.png', 'image_name' => 'Alistar', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Amumu", 'image' => 'Amumu.png', 'image_name' => 'Amumu', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Anivia", 'image' => 'Anivia.png', 'image_name' => 'Anivia', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Annie", 'image' => 'Annie.png', 'image_name' => 'Annie', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Aphelios", 'image' => 'Aphelios.png', 'image_name' => 'Aphelios', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Ashe", 'image' => 'Ashe.png', 'image_name' => 'Ashe', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 1],
            ['name' => "Aurelion Sol", 'image' => 'AurelionSol.png', 'image_name' => 'AurelionSol', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Azir", 'image' => 'Azir.png', 'image_name' => 'Azir', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Bard", 'image' => 'Bard.png', 'image_name' => 'Bard', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Bel'Veth", 'image' => 'Belveth.png', 'image_name' => 'Belveth', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Blitzcrank", 'image' => 'Blitzcrank.png', 'image_name' => 'Blitzcrank', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Brand", 'image' => 'Brand.png', 'image_name' => 'Brand', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Braum", 'image' => 'Braum.png', 'image_name' => 'Braum', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Briar", 'image' => 'Briar.png', 'image_name' => 'Briar', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Caitlyn", 'image' => 'Caitlyn.png', 'image_name' => 'Caitlyn', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Camille", 'image' => 'Camille.png', 'image_name' => 'Camille', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Cassiopeia", 'image' => 'Cassiopeia.png', 'image_name' => 'Cassiopeia', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Cho'Gath", 'image' => 'Chogath.png', 'image_name' => 'Chogath', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Corki", 'image' => 'Corki.png', 'image_name' => 'Corki', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Darius", 'image' => 'Darius.png', 'image_name' => 'Darius', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Diana", 'image' => 'Diana.png', 'image_name' => 'Diana', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Draven", 'image' => 'Draven.png', 'image_name' => 'Draven', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Dr. Mundo", 'image' => 'DrMundo.png', 'image_name' => 'DrMundo', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ekko", 'image' => 'Ekko.png', 'image_name' => 'Ekko', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Elise", 'image' => 'Elise.png', 'image_name' => 'Elise', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Evelynn", 'image' => 'Evelynn.png', 'image_name' => 'Evelynn', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ezreal", 'image' => 'Ezreal.png', 'image_name' => 'Ezreal', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Fiddlesticks", 'image' => 'Fiddlesticks.png', 'image_name' => 'Fiddlesticks', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Fiora", 'image' => 'Fiora.png', 'image_name' => 'Fiora', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Fizz", 'image' => 'Fizz.png', 'image_name' => 'Fizz', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Galio", 'image' => 'Galio.png', 'image_name' => 'Galio', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Gangplank", 'image' => 'Gangplank.png', 'image_name' => 'Gangplank', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Garen", 'image' => 'Garen.png', 'image_name' => 'Garen', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Gnar", 'image' => 'Gnar.png', 'image_name' => 'Gnar', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Gragas", 'image' => 'Gragas.png', 'image_name' => 'Gragas', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Graves", 'image' => 'Graves.png', 'image_name' => 'Graves', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Gwen", 'image' => 'Gwen.png', 'image_name' => 'Gwen', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Hecarim", 'image' => 'Hecarim.png', 'image_name' => 'Hecarim', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Heimerdinger", 'image' => 'Heimerdinger.png', 'image_name' => 'Heimerdinger', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Hwei", 'image' => 'Hwei.png', 'image_name' => 'Hwei', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Illaoi", 'image' => 'Illaoi.png', 'image_name' => 'Illaoi', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Irelia", 'image' => 'Irelia.png', 'image_name' => 'Irelia', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ivern", 'image' => 'Ivern.png', 'image_name' => 'Ivern', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Janna", 'image' => 'Janna.png', 'image_name' => 'Janna', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Jarvan IV", 'image' => 'JarvanIV.png', 'image_name' => 'JarvanIV', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Jax", 'image' => 'Jax.png', 'image_name' => 'Jax', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Jayce", 'image' => 'Jayce.png', 'image_name' => 'Jayce', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Jhin", 'image' => 'Jhin.png', 'image_name' => 'Jhin', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Jinx", 'image' => 'Jinx.png', 'image_name' => 'Jinx', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Kai'Sa", 'image' => 'Kaisa.png', 'image_name' => 'Kaisa', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Kalista", 'image' => 'Kalista.png', 'image_name' => 'Kalista', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Karma", 'image' => 'Karma.png', 'image_name' => 'Karma', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Karthus", 'image' => 'Karthus.png', 'image_name' => 'Karthus', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kassadin", 'image' => 'Kassadin.png', 'image_name' => 'Kassadin', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Katarina", 'image' => 'Katarina.png', 'image_name' => 'Katarina', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kayle", 'image' => 'Kayle.png', 'image_name' => 'Kayle', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kayn", 'image' => 'Kayn.png', 'image_name' => 'Kayn', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kennen", 'image' => 'Kennen.png', 'image_name' => 'Kennen', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kha'Zix", 'image' => 'Khazix.png', 'image_name' => 'Khazix', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kindred", 'image' => 'Kindred.png', 'image_name' => 'Kindred', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kled", 'image' => 'Kled.png', 'image_name' => 'Kled', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Kog'Maw", 'image' => 'KogMaw.png', 'image_name' => 'KogMaw', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "K'Sante", 'image' => 'KSante.png', 'image_name' => 'KSante', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "LeBlanc", 'image' => 'Leblanc.png', 'image_name' => 'Leblanc', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Lee Sin", 'image' => 'LeeSin.png', 'image_name' => 'LeeSin', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Leona", 'image' => 'Leona.png', 'image_name' => 'Leona', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Lillia", 'image' => 'Lillia.png', 'image_name' => 'Lillia', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Lissandra", 'image' => 'Lissandra.png', 'image_name' => 'Lissandra', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Lucian", 'image' => 'Lucian.png', 'image_name' => 'Lucian', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Lulu", 'image' => 'Lulu.png', 'image_name' => 'Lulu', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Lux", 'image' => 'Lux.png', 'image_name' => 'Lux', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Malphite", 'image' => 'Malphite.png', 'image_name' => 'Malphite', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Malzahar", 'image' => 'Malzahar.png', 'image_name' => 'Malzahar', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Maokai", 'image' => 'Maokai.png', 'image_name' => 'Maokai', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Master Yi", 'image' => 'MasterYi.png', 'image_name' => 'MasterYi', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Milio", 'image' => 'Milio.png', 'image_name' => 'Milio', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Miss Fortune", 'image' => 'MissFortune.png', 'image_name' => 'MissFortune', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Wukong", 'image' => 'MonkeyKing.png', 'image_name' => 'MonkeyKing', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Mordekaiser", 'image' => 'Mordekaiser.png', 'image_name' => 'Mordekaiser', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Morgana", 'image' => 'Morgana.png', 'image_name' => 'Morgana', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Naafiri", 'image' => 'Naafiri.png', 'image_name' => 'Naafiri', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Nami", 'image' => 'Nami.png', 'image_name' => 'Nami', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Nasus", 'image' => 'Nasus.png', 'image_name' => 'Nasus', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Nautilus", 'image' => 'Nautilus.png', 'image_name' => 'Nautilus', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Neeko", 'image' => 'Neeko.png', 'image_name' => 'Neeko', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 1],
            ['name' => "Nidalee", 'image' => 'Nidalee.png', 'image_name' => 'Nidalee', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Nilah", 'image' => 'Nilah.png', 'image_name' => 'Nilah', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Nocturne", 'image' => 'Nocturne.png', 'image_name' => 'Nocturne', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Nunu", 'image' => 'Nunu.png', 'image_name' => 'Nunu', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Olaf", 'image' => 'Olaf.png', 'image_name' => 'Olaf', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Orianna", 'image' => 'Orianna.png', 'image_name' => 'Orianna', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ornn", 'image' => 'Ornn.png', 'image_name' => 'Ornn', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Pantheon", 'image' => 'Pantheon.png', 'image_name' => 'Pantheon', 'top' => 1, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Poppy", 'image' => 'Poppy.png', 'image_name' => 'Poppy', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Pyke", 'image' => 'Pyke.png', 'image_name' => 'Pyke', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Qiyana", 'image' => 'Qiyana.png', 'image_name' => 'Qiyana', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Quinn", 'image' => 'Quinn.png', 'image_name' => 'Quinn', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Rakan", 'image' => 'Rakan.png', 'image_name' => 'Rakan', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Rammus", 'image' => 'Rammus.png', 'image_name' => 'Rammus', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Rek'Sai", 'image' => 'RekSai.png', 'image_name' => 'RekSai', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Rell", 'image' => 'Rell.png', 'image_name' => 'Rell', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Renata Glasc", 'image' => 'Renata.png', 'image_name' => 'Renata', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Renekton", 'image' => 'Renekton.png', 'image_name' => 'Renekton', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Rengar", 'image' => 'Rengar.png', 'image_name' => 'Rengar', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Riven", 'image' => 'Riven.png', 'image_name' => 'Riven', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Rumble", 'image' => 'Rumble.png', 'image_name' => 'Rumble', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Ryze", 'image' => 'Ryze.png', 'image_name' => 'Ryze', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Samira", 'image' => 'Samira.png', 'image_name' => 'Samira', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Sejuani", 'image' => 'Sejuani.png', 'image_name' => 'Sejuani', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Senna", 'image' => 'Senna.png', 'image_name' => 'Senna', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 1],
            ['name' => "Seraphine", 'image' => 'Seraphine.png', 'image_name' => 'Seraphine', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 1],
            ['name' => "Sett", 'image' => 'Sett.png', 'image_name' => 'Sett', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Shaco", 'image' => 'Shaco.png', 'image_name' => 'Shaco', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Shen", 'image' => 'Shen.png', 'image_name' => 'Shen', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Shyvana", 'image' => 'Shyvana.png', 'image_name' => 'Shyvana', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Singed", 'image' => 'Singed.png', 'image_name' => 'Singed', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Sion", 'image' => 'Sion.png', 'image_name' => 'Sion', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Sivir", 'image' => 'Sivir.png', 'image_name' => 'Sivir', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Skarner", 'image' => 'Skarner.png', 'image_name' => 'Skarner', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Smolder", 'image' => 'Smolder.png', 'image_name' => 'Smolder', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Sona", 'image' => 'Sona.png', 'image_name' => 'Sona', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Soraka", 'image' => 'Soraka.png', 'image_name' => 'Soraka', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Swain", 'image' => 'Swain.png', 'image_name' => 'Swain', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Sylas", 'image' => 'Sylas.png', 'image_name' => 'Sylas', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Syndra", 'image' => 'Syndra.png', 'image_name' => 'Syndra', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Tahm Kench", 'image' => 'TahmKench.png', 'image_name' => 'TahmKench', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Taliyah", 'image' => 'Taliyah.png', 'image_name' => 'Taliyah', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Talon", 'image' => 'Talon.png', 'image_name' => 'Talon', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Taric", 'image' => 'Taric.png', 'image_name' => 'Taric', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Teemo", 'image' => 'Teemo.png', 'image_name' => 'Teemo', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Thresh", 'image' => 'Thresh.png', 'image_name' => 'Thresh', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Tristana", 'image' => 'Tristana.png', 'image_name' => 'Tristana', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 1, 'utility' => 0],
            ['name' => "Trundle", 'image' => 'Trundle.png', 'image_name' => 'Trundle', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Tryndamere", 'image' => 'Tryndamere.png', 'image_name' => 'Tryndamere', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Twisted Fate", 'image' => 'TwistedFate.png', 'image_name' => 'TwistedFate', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 1, 'utility' => 0],
            ['name' => "Twitch", 'image' => 'Twitch.png', 'image_name' => 'Twitch', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 1],
            ['name' => "Udyr", 'image' => 'Udyr.png', 'image_name' => 'Udyr', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Urgot", 'image' => 'Urgot.png', 'image_name' => 'Urgot', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Varus", 'image' => 'Varus.png', 'image_name' => 'Varus', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Vayne", 'image' => 'Vayne.png', 'image_name' => 'Vayne', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Veigar", 'image' => 'Veigar.png', 'image_name' => 'Veigar', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Vel'Koz", 'image' => 'Velkoz.png', 'image_name' => 'Velkoz', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Vex", 'image' => 'Vex.png', 'image_name' => 'Vex', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Vi", 'image' => 'Vi.png', 'image_name' => 'Vi', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Viego", 'image' => 'Viego.png', 'image_name' => 'Viego', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Viktor", 'image' => 'Viktor.png', 'image_name' => 'Viktor', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Vladimir", 'image' => 'Vladimir.png', 'image_name' => 'Vladimir', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Volibear", 'image' => 'Volibear.png', 'image_name' => 'Volibear', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Warwick", 'image' => 'Warwick.png', 'image_name' => 'Warwick', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Xayah", 'image' => 'Xayah.png', 'image_name' => 'Xayah', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Xerath", 'image' => 'Xerath.png', 'image_name' => 'Xerath', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 1],
            ['name' => "Xin Zhao", 'image' => 'XinZhao.png', 'image_name' => 'XinZhao', 'top' => 0, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Yasuo", 'image' => 'Yasuo.png', 'image_name' => 'Yasuo', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 1, 'utility' => 0],
            ['name' => "Yone", 'image' => 'Yone.png', 'image_name' => 'Yone', 'top' => 1, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Yorick", 'image' => 'Yorick.png', 'image_name' => 'Yorick', 'top' => 1, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 0],
            ['name' => "Yuumi", 'image' => 'Yuumi.png', 'image_name' => 'Yuumi', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Zac", 'image' => 'Zac.png', 'image_name' => 'Zac', 'top' => 1, 'jungle' => 1, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Zed", 'image' => 'Zed.png', 'image_name' => 'Zed', 'top' => 0, 'jungle' => 1, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Zeri", 'image' => 'Zeri.png', 'image_name' => 'Zeri', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 1, 'utility' => 0],
            ['name' => "Ziggs", 'image' => 'Ziggs.png', 'image_name' => 'Ziggs', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 1, 'utility' => 0],
            ['name' => "Zilean", 'image' => 'Zilean.png', 'image_name' => 'Zilean', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1],
            ['name' => "Zoe", 'image' => 'Zoe.png', 'image_name' => 'Zoe', 'top' => 0, 'jungle' => 0, 'middle' => 1, 'bottom' => 0, 'utility' => 0],
            ['name' => "Zyra", 'image' => 'Zyra.png', 'image_name' => 'Zyra', 'top' => 0, 'jungle' => 0, 'middle' => 0, 'bottom' => 0, 'utility' => 1]
        ];

        foreach ($champions as $champion) {
            Champion::create([
                'name'       => $champion['name'],
                // 'image'   => '/images/champion/'.$champion['image'],
                'image'      => $champion['image'],
                'image_name' => $champion['image_name'],
                'top'        => $champion['top'],
                'jungle'     => $champion['jungle'],
                'middle'     => $champion['middle'],
                'bottom'     => $champion['bottom'],
                'utility'    => $champion['utility']
            ]);
        }
    }
}
