<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->id();
            $table->string('room_id');
            $table->string('password');
            $table->text('blue_name');
            $table->text('red_name');
            $table->string('blue_team');
            $table->string('red_team');
            $table->enum('type', ['Tournament', 'Fearless'])->default('Tournament');
            $table->json('data')->nullable();
            $table->boolean('red_sound')->default(0);
            $table->boolean('blue_sound')->default(0);
            $table->boolean('spectator_sound')->default(0);
            $table->enum('red_size', ['Large', 'Small'])->default('Large');
            $table->enum('blue_size', ['Large', 'Small'])->default('Large');
            $table->enum('spectator_size', ['Large', 'Small'])->default('Large');
            $table->json('blue_import')->nullable();
            $table->json('red_import')->nullable();
            $table->enum('blue_ban', ['On', 'Off'])->default('Off');
            $table->enum('red_ban', ['On', 'Off'])->default('Off');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teams');
    }
};
